/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.datagen;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.configurations.EnumConfiguration;

@Environment(value=EnvType.CLIENT)
public class PneumonoCoreTranslationBuilder {
    private final FabricLanguageProvider.TranslationBuilder builder;
    private final String modId;

    public PneumonoCoreTranslationBuilder(FabricLanguageProvider.TranslationBuilder builder, String modId) {
        this.builder = builder;
        this.modId = modId;
    }

    @Deprecated
    public PneumonoCoreTranslationBuilder(FabricLanguageProvider.TranslationBuilder builder) {
        this(builder, null);
    }

    public void add(String key, String value) {
        this.builder.add(key, value);
    }

    public void add(class_1792 item, String value) {
        this.builder.add(item, value);
    }

    public void add(class_1792 item, String value, String suffix) {
        this.builder.add(item.method_7876() + "." + suffix, value);
    }

    public void add(class_2248 block, String value) {
        this.builder.add(block, value);
    }

    public void add(class_2248 block, String value, String suffix) {
        this.builder.add(block.method_9539() + "." + suffix, value);
    }

    public void add(class_1299<?> type, String value) {
        this.builder.add(type, value);
    }

    public void add(class_1299<?> type, String value, String suffix) {
        this.builder.add(type.method_5882() + "." + suffix, value);
    }

    public void add(class_3448<?> type, String value) {
        this.builder.add(type, value);
    }

    public void add(class_1291 effect, String value) {
        this.builder.add(effect, value);
    }

    public void add(class_6862<?> key, String value) {
        this.builder.add(key, value);
    }

    public void add(class_3414 sound, String value) {
        this.builder.add(class_156.method_646((String)"subtitles", (class_2960)sound.method_14833()), value);
    }

    public void add(Path existingLangFile) throws IOException {
        this.builder.add(existingLangFile);
    }

    public void addItemGroup(class_5321<class_1761> key, String value) {
        this.builder.add(key, value);
    }

    public void addEnchantment(class_5321<class_1887> key, String value) {
        this.builder.addEnchantment(key, value);
    }

    public void addEntityAttribute(class_6880<class_1320> entry, String value) {
        this.builder.add(entry, value);
    }

    public void add(class_2960 key, String value) {
        this.builder.add(key, value);
    }

    public void add(class_2960 key, String value, String prefix) {
        this.builder.add(key.method_42093(prefix), value);
    }

    public void add(class_2960 key, String value, String prefix, String suffix) {
        this.builder.add(key.method_48747(prefix, suffix), value);
    }

    public void addStat(class_2960 stat, String value) {
        this.builder.add(stat.method_42093("stat"), value);
    }

    public void addAdvancement(class_2960 id, String name, String description) {
        this.builder.add(id.method_48747("advancements", "name"), name);
        this.builder.add(id.method_48747("advancements", "description"), description);
    }

    public void addConfigScreenTitle(String title) {
        this.builder.add("configs." + this.modId + ".screen_title", title);
    }

    @Deprecated
    public void addConfigScreenTitle(String modId, String title) {
        this.builder.add("configs." + modId + ".screen_title", title);
    }

    public void addConfig(net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration<?> config, String name, String tooltip) {
        this.builder.add(ConfigApi.toTranslationKey(config), name);
        this.builder.add(ConfigApi.toTranslationKey(config, "tooltip"), tooltip);
    }

    @Deprecated
    public void addConfig(AbstractConfiguration<?, ?> config, String name, String tooltip) {
        this.addConfig((net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration<?>)config.getWrappedConfiguration(), name, tooltip);
    }

    public <T extends Enum<T>> void addEnumConfig(EnumConfiguration<T> config, String name, String tooltip, String ... values) {
        this.addConfig(config, name, tooltip);
        Enum[] keys = (Enum[])((Enum)config.info().getDefaultValue()).getDeclaringClass().getEnumConstants();
        if (keys.length != values.length) {
            throw new IllegalArgumentException("The number of enum values and translation strings must match!");
        }
        for (int i = 0; i < keys.length; ++i) {
            this.builder.add(ConfigApi.toTranslationKey(config, keys[i].toString().toLowerCase()), values[i]);
        }
    }

    @Deprecated
    public <T extends Enum<T>> void addEnumConfig(net.pneumono.pneumonocore.config.EnumConfiguration<T> config, String name, String tooltip, String ... values) {
        this.addConfig((net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration<?>)config.getWrappedConfiguration(), name, tooltip);
    }

    public void addConfigCategory(String category, String name) {
        this.builder.add("configs.category." + this.modId + "." + category, name);
    }

    @Deprecated
    public void addConfigCategory(String modId, String category, String name) {
        this.builder.add("configs.category." + modId + "." + category, name);
    }

    public void addModMenuTexts(String name, String summary) {
        this.addModMenuTexts(name, summary, summary);
    }

    @Deprecated
    public void addModMenuTranslations(String modId, String name, String summary) {
        this.addModMenuTranslations(modId, name, summary, summary);
    }

    public void addModMenuTexts(String name, String summary, String description) {
        this.builder.add("modmenu.nameTranslation." + this.modId, name);
        this.builder.add("modmenu.summaryTranslation." + this.modId, summary);
        this.builder.add("modmenu.descriptionTranslation." + this.modId, description);
    }

    @Deprecated
    public void addModMenuTranslations(String modId, String name, String summary, String description) {
        this.builder.add("modmenu.nameTranslation." + modId, name);
        this.builder.add("modmenu.summaryTranslation." + modId, summary);
        this.builder.add("modmenu.descriptionTranslation." + modId, description);
    }

    public <T> BiConsumer<T, String> createBuilder(Function<T, String> keyFunction) {
        return (object, value) -> this.builder.add((String)keyFunction.apply(object), value);
    }
}

